# Generated by Django 5.2.8 on 2025-12-19 19:22

import django.core.validators
import django.db.models.deletion
import orgapy.utils
from django.conf import settings
from django.db import migrations, models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name="Calendar",
            fields=[
                ("id", models.BigAutoField(primary_key=True, serialize=False)),
                ("url", models.URLField(max_length=255)),
                ("username", models.CharField(max_length=255)),
                ("password", models.CharField(max_length=255)),
                ("calendar_name", models.CharField(max_length=255)),
                ("last_sync", models.DateTimeField(blank=True, null=True)),
                ("sync_period", models.PositiveIntegerField(default=86400)),
                ("events", models.TextField(blank=True, null=True)),
                (
                    "user",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
            ],
            options={
                "ordering": ["user"],
            },
        ),
        migrations.CreateModel(
            name="Category",
            fields=[
                ("id", models.BigAutoField(primary_key=True, serialize=False)),
                ("name", models.CharField(max_length=255)),
                (
                    "user",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
            ],
            options={
                "ordering": ["name"],
            },
        ),
        migrations.CreateModel(
            name="Map",
            fields=[
                ("id", models.BigAutoField(primary_key=True, serialize=False)),
                ("date_creation", models.DateTimeField(auto_now_add=True)),
                ("date_modification", models.DateTimeField(auto_now_add=True)),
                ("date_access", models.DateTimeField(auto_now_add=True)),
                ("title", models.CharField(max_length=255)),
                ("public", models.BooleanField(default=False)),
                ("pinned", models.BooleanField(default=False)),
                ("hidden", models.BooleanField(default=False)),
                (
                    "nonce",
                    models.TextField(
                        blank=True,
                        default=orgapy.utils.generate_nonce,
                        max_length=12,
                        unique=True,
                    ),
                ),
                ("deleted", models.BooleanField(default=False)),
                ("date_deletion", models.DateTimeField(blank=True, null=True)),
                ("geojson", models.TextField(blank=True, null=True)),
                ("config", models.TextField(blank=True, null=True)),
                (
                    "categories",
                    models.ManyToManyField(
                        blank=True, related_name="maps", to="orgapy.category"
                    ),
                ),
                (
                    "user",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
            ],
            options={
                "ordering": ["-date_modification"],
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="Note",
            fields=[
                ("id", models.BigAutoField(primary_key=True, serialize=False)),
                ("date_creation", models.DateTimeField(auto_now_add=True)),
                ("date_modification", models.DateTimeField(auto_now_add=True)),
                ("date_access", models.DateTimeField(auto_now_add=True)),
                ("title", models.CharField(max_length=255)),
                ("public", models.BooleanField(default=False)),
                ("pinned", models.BooleanField(default=False)),
                ("hidden", models.BooleanField(default=False)),
                (
                    "nonce",
                    models.TextField(
                        blank=True,
                        default=orgapy.utils.generate_nonce,
                        max_length=12,
                        unique=True,
                    ),
                ),
                ("deleted", models.BooleanField(default=False)),
                ("date_deletion", models.DateTimeField(blank=True, null=True)),
                ("content", models.TextField()),
                (
                    "categories",
                    models.ManyToManyField(
                        blank=True, related_name="notes", to="orgapy.category"
                    ),
                ),
                (
                    "map_refs",
                    models.ManyToManyField(
                        related_name="referenced_in", to="orgapy.map"
                    ),
                ),
                (
                    "note_refs",
                    models.ManyToManyField(
                        related_name="referenced_in", to="orgapy.note"
                    ),
                ),
                (
                    "user",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
            ],
            options={
                "ordering": ["-date_modification"],
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="Objective",
            fields=[
                ("id", models.BigAutoField(primary_key=True, serialize=False)),
                ("name", models.CharField(max_length=255)),
                ("history", models.TextField(blank=True, null=True)),
                (
                    "period",
                    models.PositiveIntegerField(
                        default=1,
                        validators=[
                            django.core.validators.MinValueValidator(1),
                            django.core.validators.MaxValueValidator(365),
                        ],
                    ),
                ),
                ("flexible", models.BooleanField(default=False)),
                ("archived", models.BooleanField(default=False)),
                (
                    "user",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
            ],
            options={
                "ordering": ["name"],
            },
        ),
        migrations.CreateModel(
            name="ProgressLog",
            fields=[
                ("id", models.BigAutoField(primary_key=True, serialize=False)),
                ("dt", models.DateTimeField(auto_now_add=True)),
                (
                    "type",
                    models.CharField(
                        choices=[
                            ("OT", "Other"),
                            ("PR", "Project checklist item checked"),
                            ("TA", "Task completed"),
                            ("OB", "Objective completed"),
                        ],
                        default="OT",
                        max_length=2,
                    ),
                ),
                (
                    "description",
                    models.CharField(blank=True, max_length=255, null=True),
                ),
                (
                    "user",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
            ],
            options={
                "ordering": ["-dt"],
            },
        ),
        migrations.CreateModel(
            name="Project",
            fields=[
                ("id", models.BigAutoField(primary_key=True, serialize=False)),
                ("date_creation", models.DateTimeField(auto_now_add=True)),
                ("date_modification", models.DateTimeField(auto_now=True)),
                ("title", models.CharField(max_length=255)),
                ("category", models.CharField(default="general", max_length=255)),
                ("limit_date", models.DateField(blank=True, null=True)),
                ("progress_min", models.PositiveIntegerField(blank=True, null=True)),
                ("progress_max", models.PositiveIntegerField(blank=True, null=True)),
                (
                    "progress_current",
                    models.PositiveIntegerField(blank=True, null=True),
                ),
                ("description", models.TextField(blank=True, null=True)),
                ("checklist", models.TextField(blank=True, null=True)),
                ("rank", models.FloatField()),
                ("archived", models.BooleanField(default=False)),
                (
                    "note",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        to="orgapy.note",
                    ),
                ),
                (
                    "user",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
            ],
            options={
                "ordering": ["-date_creation"],
            },
        ),
        migrations.CreateModel(
            name="PushSubscription",
            fields=[
                ("id", models.BigAutoField(primary_key=True, serialize=False)),
                ("subscription", models.TextField()),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("name", models.CharField(blank=True, max_length=255, null=True)),
                (
                    "user",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
            ],
            options={
                "ordering": ["user"],
            },
        ),
        migrations.CreateModel(
            name="Quote",
            fields=[
                ("id", models.BigAutoField(primary_key=True, serialize=False)),
                ("date_creation", models.DateTimeField(auto_now_add=True)),
                ("date_modification", models.DateTimeField(auto_now_add=True)),
                ("content", models.TextField()),
                ("reference", models.CharField(blank=True, default="", max_length=255)),
                (
                    "user",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
            ],
            options={
                "ordering": ["-date_creation"],
            },
        ),
        migrations.CreateModel(
            name="Settings",
            fields=[
                ("id", models.BigAutoField(primary_key=True, serialize=False)),
                (
                    "objective_start_hours",
                    models.PositiveIntegerField(
                        default=0,
                        validators=[
                            django.core.validators.MinValueValidator(0),
                            django.core.validators.MaxValueValidator(23),
                        ],
                    ),
                ),
                ("calendar_lookahead", models.PositiveIntegerField(default=3)),
                ("beach_mode", models.BooleanField(default=False)),
                ("trash_period", models.PositiveIntegerField(default=30)),
                (
                    "user",
                    models.OneToOneField(
                        on_delete=django.db.models.deletion.CASCADE,
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
            ],
            options={
                "ordering": ["user"],
            },
        ),
        migrations.CreateModel(
            name="Sheet",
            fields=[
                ("id", models.BigAutoField(primary_key=True, serialize=False)),
                ("date_creation", models.DateTimeField(auto_now_add=True)),
                ("date_modification", models.DateTimeField(auto_now_add=True)),
                ("date_access", models.DateTimeField(auto_now_add=True)),
                ("title", models.CharField(max_length=255)),
                ("public", models.BooleanField(default=False)),
                ("pinned", models.BooleanField(default=False)),
                ("hidden", models.BooleanField(default=False)),
                (
                    "nonce",
                    models.TextField(
                        blank=True,
                        default=orgapy.utils.generate_nonce,
                        max_length=12,
                        unique=True,
                    ),
                ),
                ("deleted", models.BooleanField(default=False)),
                ("date_deletion", models.DateTimeField(blank=True, null=True)),
                ("description", models.TextField(blank=True, null=True)),
                ("data", models.TextField(blank=True, null=True)),
                ("config", models.TextField(blank=True, null=True)),
                (
                    "categories",
                    models.ManyToManyField(
                        blank=True, related_name="sheets", to="orgapy.category"
                    ),
                ),
                (
                    "user",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
            ],
            options={
                "ordering": ["-date_modification"],
                "abstract": False,
            },
        ),
        migrations.AddField(
            model_name="note",
            name="sheet_refs",
            field=models.ManyToManyField(
                related_name="referenced_in", to="orgapy.sheet"
            ),
        ),
        migrations.CreateModel(
            name="SheetGroup",
            fields=[
                ("id", models.BigAutoField(primary_key=True, serialize=False)),
                ("title", models.CharField(max_length=255)),
                (
                    "user",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
            ],
            options={
                "ordering": ["title"],
            },
        ),
        migrations.AddField(
            model_name="sheet",
            name="group",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                to="orgapy.sheetgroup",
            ),
        ),
        migrations.CreateModel(
            name="Task",
            fields=[
                ("id", models.BigAutoField(primary_key=True, serialize=False)),
                ("title", models.CharField(max_length=255)),
                ("start_date", models.DateField()),
                ("due_date", models.DateField(blank=True, null=True)),
                (
                    "recurring_mode",
                    models.CharField(
                        choices=[
                            ("ON", "Once"),
                            ("DY", "Daily"),
                            ("WK", "Weekly"),
                            ("MN", "Monthly"),
                            ("YR", "Yearly"),
                        ],
                        default="ON",
                        max_length=2,
                    ),
                ),
                (
                    "recurring_period",
                    models.PositiveIntegerField(blank=True, null=True),
                ),
                ("completed", models.BooleanField(default=False)),
                ("date_completion", models.DateTimeField(blank=True, null=True)),
                (
                    "recurring_parent",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        to="orgapy.task",
                    ),
                ),
                (
                    "user",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
            ],
            options={
                "ordering": ["-start_date"],
            },
        ),
        migrations.CreateModel(
            name="ProgressCounter",
            fields=[
                ("id", models.BigAutoField(primary_key=True, serialize=False)),
                ("year", models.PositiveIntegerField()),
                ("data", models.TextField(default="{}")),
                (
                    "user",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
            ],
            options={
                "ordering": ["user", "-year"],
                "constraints": [
                    models.UniqueConstraint(
                        fields=("user", "year"), name="unique_user_year"
                    )
                ],
            },
        ),
    ]
