from django.urls import path
from .views import base as views
from .views.api import api

app_name = "orgapy"

urlpatterns = [
    path("", views.view_landing, name="landing"),
    path("about", views.view_about, name="about"),
    path("projects", views.view_projects, name="projects"),
    path("search", views.view_search, name="search"),
    path("categories/", views.view_categories, name="categories"),
    path("categories/<name>", views.view_category, name="category"),
    path("categories/<object_id>/edit", views.view_edit_category, name="edit_category"),
    path("categories/<object_id>/delete", views.view_delete_category, name="delete_category"),
    path("notes", views.view_notes, name="notes"),
    path("notes/create", views.view_create_note, name="create_note"),
    path("notes/save", views.view_save_note, name="save_note"),
    path("notes/notally", views.view_notally, name="notally"),
    path("notes/<object_id>", views.view_note, name="note"),
    path("notes/<object_id>/edit", views.view_edit_note, name="edit_note"),
    path("notes/<object_id>/export", views.view_export_note, name="export_note"),
    path("notes/<object_id>/delete", views.view_delete_note, name="delete_note"),
    path("notes/<object_id>/pin", views.view_toggle_note_pin, name="toggle_note_pin"),
    path("notes/<object_id>/public", views.view_toggle_note_public, name="toggle_note_public"),
    path("notes/<object_id>/restore", views.view_restore_note, name="restore_note"),
    path("notes/<object_id>/destroy", views.view_destroy_note, name="destroy_note"),
    path("sheets", views.view_sheets, name="sheets"),
    path("sheets/create", views.view_create_sheet, name="create_sheet"),
    path("sheets/save", views.view_save_sheet, name="save_sheet"),
    path("sheets/<object_id>", views.view_sheet, name="sheet"),
    path("sheets/<object_id>/edit", views.view_edit_sheet, name="edit_sheet"),
    path("sheets/<object_id>/export", views.view_export_sheet, name="export_sheet"),
    path("sheets/<object_id>/delete", views.view_delete_sheet, name="delete_sheet"),
    path("sheets/<object_id>/pin", views.view_toggle_sheet_pin, name="toggle_sheet_pin"),
    path("sheets/<object_id>/public", views.view_toggle_sheet_public, name="toggle_sheet_public"),
    path("sheets/<object_id>/restore", views.view_restore_sheet, name="restore_sheet"),
    path("sheets/<object_id>/destroy", views.view_destroy_sheet, name="destroy_sheet"),
    path("maps", views.view_maps, name="maps"),
    path("maps/create", views.view_create_map, name="create_map"),
    path("maps/save", views.view_save_map, name="save_map"),
    path("maps/<object_id>", views.view_map, name="map"),
    path("maps/<object_id>/edit", views.view_edit_map, name="edit_map"),
    path("maps/<object_id>/export", views.view_export_map, name="export_map"),
    path("maps/<object_id>/delete", views.view_delete_map, name="delete_map"),
    path("maps/<object_id>/pin", views.view_toggle_map_pin, name="toggle_map_pin"),
    path("maps/<object_id>/public", views.view_toggle_map_public, name="toggle_map_public"),
    path("maps/<object_id>/restore", views.view_restore_map, name="restore_map"),
    path("maps/<object_id>/destroy", views.view_destroy_map, name="destroy_map"),
    path("progress", views.view_progress, name="progress"),
    path("progress/log/create", views.view_create_progress_log, name="create_progress_log"),
    path("progress/log/save", views.view_save_progress_log, name="save_progress_log"),
    path("progress/log/<object_id>", views.view_edit_progress_log, name="edit_progress_log"),
    path("progress/log/<object_id>/delete", views.view_delete_progress_log, name="delete_progress_log"),
    path("progress/<year>", views.view_progress, name="progress_year"),
    path("progress/<year>/compute", views.view_progress_compute, name="progress_compute"),
    path("settings", views.view_settings, name="settings"),
    path("settings/calendar", views.view_calendar_form, name="calendar_form"),
    path("<active>/<object_id>/edit", views.view_edit, name="edit"),
    path("<active>/<object_id>/export", views.view_export, name="export"),
    path("<active>/<object_id>/delete", views.view_delete, name="delete"),
    path("<active>/<object_id>/pin", views.view_toggle_pin, name="toggle_pin"),
    path("<active>/<object_id>/public", views.view_toggle_public, name="toggle_public"),
    path("<active>/<object_id>/restore", views.view_restore, name="restore"),
    path("<active>/<object_id>/destroy", views.view_destroy, name="destroy"),
    path("<active>/<nonce>/share", views.view_share, name="share"),
    path("trash", views.view_trash, name="trash"),
    path("trash/restore", views.view_restore_all, name="restore_all"),
    path("trash/destroy", views.view_destroy_all, name="destroy_all"),
    path("subscription/<object_id>/delete", views.view_delete_subscription, name="delete_subscription"),
    path("api", api, name="api"),
]
